/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.array;

import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.operators.EqualsEquals;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Function;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="ArrayFindAllNoCase")})
@BoxMembers(value={@BoxMember(type=BoxLangType.ARRAY), @BoxMember(type=BoxLangType.ARRAY, name="findAllNoCase")})
public class ArrayFindAll
extends BIF {
    public ArrayFindAll() {
        this.declaredArguments = new Argument[]{new Argument(true, "array", Key.array), new Argument(true, "any", Key.value)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Array actualArray = arguments.getAsArray(Key.array);
        Object value = arguments.get(Key.value);
        IntPredicate test = this.getPredicate(context, actualArray, value, this.isCaseSensitive(arguments.getAsKey(BIF.__functionName)));
        return Array.fromList(actualArray.intStream().filter(test).map(i -> i + 1).boxed().collect(Collectors.toList()));
    }

    private IntPredicate getPredicate(IBoxContext context, Array actualArray, Object value, boolean caseSensitive) {
        if (value instanceof Function) {
            Function functionValue = (Function)value;
            return i -> BooleanCaster.cast(context.invokeFunction((Object)functionValue, new Object[]{actualArray.get(i)}));
        }
        return i -> EqualsEquals.invoke(actualArray.get(i), value, caseSensitive) != false || actualArray.get(i).equals(value);
    }

    private boolean isCaseSensitive(Key functionName) {
        return functionName.equals(Key.findAll) || functionName.equals(Key.arrayFindAll);
    }
}

