/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.array;

import java.util.List;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.operators.Compare;
import ortus.boxlang.runtime.operators.Divide;
import ortus.boxlang.runtime.operators.Plus;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIF
@BoxMember(type=BoxLangType.ARRAY)
public class ArrayMedian
extends BIF {
    public ArrayMedian() {
        this.declaredArguments = new Argument[]{new Argument(true, "array", Key.array)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Array actualArray = arguments.getAsArray(Key.array);
        List vals = actualArray.stream().map(x -> NumberCaster.cast(x)).collect(Collectors.toList());
        int size = actualArray.size();
        vals.sort(Compare::invoke);
        if (size % 2 == 1) {
            return vals.get(size / 2);
        }
        int median = size / 2;
        return Divide.invoke(Plus.invoke(vals.get(median - 1), vals.get(median)), 2);
    }
}

