/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.array;

import java.util.stream.IntStream;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.BLCollector;

@BoxBIF
@BoxMember(type=BoxLangType.ARRAY)
public class ArrayRange
extends BIF {
    public ArrayRange() {
        this.declaredArguments = new Argument[]{new Argument(false, "any", Key.from, 1), new Argument(false, "numeric", Key.to)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String castedFrom;
        Object incomingFrom = arguments.get(Key.from);
        Object incomingTo = arguments.get(Key.to);
        Integer from = 1;
        Integer to = null;
        if (incomingFrom instanceof String && (castedFrom = (String)incomingFrom).contains("..")) {
            String[] range = castedFrom.split("\\.{2}");
            from = IntegerCaster.cast(range[0]);
            to = range.length > 1 ? IntegerCaster.cast(range[1]) : from;
        } else {
            from = IntegerCaster.cast(incomingFrom);
            Integer n = to = incomingTo != null ? IntegerCaster.cast(incomingTo) : from;
        }
        if (to < from) {
            to = from;
        }
        return IntStream.rangeClosed(from, to).boxed().collect(BLCollector.toArray());
    }
}

