/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.array;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="ArrayMid")})
@BoxMembers(value={@BoxMember(type=BoxLangType.ARRAY), @BoxMember(type=BoxLangType.ARRAY, name="mid")})
public class ArraySlice
extends BIF {
    public ArraySlice() {
        this.declaredArguments = new Argument[]{new Argument(true, "array", Key.array), new Argument(true, "integer", Key.start, 1), new Argument(false, "integer", Key.length, 0)};
    }

    @Override
    public Array _invoke(IBoxContext context, ArgumentsScope arguments) {
        Array actualArray = arguments.getAsArray(Key.array);
        int start = arguments.getAsInteger(Key.start) - 1;
        int length = arguments.getAsInteger(Key.length);
        Array outputArray = new Array();
        if (start < 0) {
            start = actualArray.size() + arguments.getAsInteger(Key.start);
        }
        if (length < 0) {
            length = actualArray.size() + length - start;
        } else if (length == 0) {
            length = actualArray.size() - start;
        }
        for (int i = start; i < start + length; ++i) {
            if (i >= actualArray.size()) continue;
            outputArray.add(actualArray.get(i));
        }
        return outputArray;
    }
}

