/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.array;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.FunctionCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIF
@BoxMember(type=BoxLangType.ARRAY)
public class ArraySort
extends BIF {
    public ArraySort() {
        this.declaredArguments = new Argument[]{new Argument(true, "modifiablearray", Key.array), new Argument(false, "any", Key.sortType, "textnocase"), new Argument(false, "string", Key.sortOrder, "asc"), new Argument(false, "boolean", Key.localeSensitive), new Argument(false, "function:Comparator", Key.callback)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        CastAttempt<Function> funcAttempt;
        Array array = arguments.getAsArray(Key.array);
        Function callback = arguments.getAsFunction(Key.callback);
        Object sortType = arguments.get(Key.sortType);
        String sortOrder = arguments.getAsString(Key.sortOrder);
        if (sortType != null && (funcAttempt = FunctionCaster.attempt(sortType, "Comparator")).wasSuccessful()) {
            callback = funcAttempt.get();
        }
        Array result = null;
        result = callback != null ? ListUtil.sort(array, callback, context) : ListUtil.sort(array, StringCaster.cast(sortType), sortOrder, LocalizationUtil.parseLocaleFromContext(context, arguments));
        return result;
    }
}

