/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.async;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.util.RequestThreadManager;

@BoxBIF
public class ThreadJoin
extends BIF {
    public ThreadJoin() {
        this.declaredArguments = new Argument[]{new Argument(false, "string", Key.threadName, ""), new Argument(false, "numeric", Key.timeout, 0)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String threadNames = arguments.getAsString(Key.threadName);
        Object t = arguments.get(Key.timeout);
        Integer timeout = t != null ? IntegerCaster.cast(arguments.get(Key.timeout)) : 0;
        Array aThreadNames = ListUtil.asList(threadNames, ",").stream().map(String::valueOf).map(String::trim).collect(BLCollector.toArray());
        RequestThreadManager manager = context.getParentOfType(RequestBoxContext.class).getThreadManager();
        if (aThreadNames.isEmpty()) {
            manager.joinAllThreads(timeout);
        } else {
            manager.joinThreads(aThreadNames, timeout);
        }
        return null;
    }
}

