/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.async;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.context.ThreadBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.util.RequestThreadManager;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIF
public class ThreadNew
extends BIF {
    public ThreadNew() {
        this.declaredArguments = new Argument[]{new Argument(true, "function", Key.runnable), new Argument(false, "struct", Key.attributes, new Struct()), new Argument(false, "string", Key._NAME, ""), new Argument(false, "string", Key.priority, (Object)"normal", Set.of(Validator.valueOneOf("high", "low", "normal")))};
    }

    @Override
    public Thread _invoke(IBoxContext context, ArgumentsScope arguments) {
        Function task = arguments.getAsFunction(Key.runnable);
        String name = arguments.getAsString(Key._NAME);
        String priority = arguments.getAsString(Key.priority);
        IStruct attributes = arguments.getAsStruct(Key.attributes);
        RequestThreadManager threadManager = context.getParentOfType(RequestBoxContext.class).getThreadManager();
        Key nameKey = RequestThreadManager.ensureThreadName(name);
        ThreadBoxContext tContext = threadManager.createThreadContext(context, nameKey);
        return threadManager.startThread(tContext, nameKey, priority, () -> {
            StringBuffer buffer = new StringBuffer();
            Throwable exception = null;
            Logger logger2 = LoggerFactory.getLogger(ThreadNew.class);
            try {
                tContext.invokeFunction(task);
            }
            catch (AbortException e) {
                logger2.debug("Thread [{}] aborted at stacktrace: {}", (Object)nameKey.getName(), (Object)e.getStackTrace());
            }
            catch (Throwable e) {
                exception = e;
                logger2.error("Thread [{}] terminated with exception: {}", (Object)nameKey.getName(), (Object)e.getMessage());
                logger2.error("-> Exception", e);
            }
            finally {
                threadManager.completeThread(nameKey, buffer.toString(), exception, Thread.interrupted());
            }
        }, attributes);
    }
}

