/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.binary;

import java.util.Base64;
import java.util.HexFormat;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class BinaryDecode
extends BIF {
    public BinaryDecode() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string), new Argument(true, "string", Key.encoding)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Key encodingKey = Key.of(arguments.getAsString(Key.encoding));
        String ref = arguments.getAsString(Key.string);
        if (encodingKey.equals(Key.encodingHex)) {
            return HexFormat.of().parseHex(ref);
        }
        if (encodingKey.equals(Key.encodingUU)) {
            return Base64.getMimeDecoder().decode(ref);
        }
        if (encodingKey.equals(Key.encodingBase64)) {
            return Base64.getDecoder().decode(ref);
        }
        if (encodingKey.equals(Key.encodingBase64Url)) {
            return Base64.getUrlDecoder().decode(ref);
        }
        throw new BoxRuntimeException(String.format("The encoding argument [%s] is not a valid encoding type for the function BinaryEncode", encodingKey.getName()));
    }
}

