/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.binary;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class BitMaskRead
extends BIF {
    public BitMaskRead() {
        this.declaredArguments = new Argument[]{new Argument(true, "integer", Key.number), new Argument(true, "integer", Key.start), new Argument(true, "integer", Key.length)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        int number = arguments.getAsInteger(Key.number);
        int start = arguments.getAsInteger(Key.start);
        int length = arguments.getAsInteger(Key.length);
        if (start < 0 || start > 31) {
            throw new BoxRuntimeException("Start must be in the range 0-31, inclusive.");
        }
        if (length < 0 || length > 31) {
            throw new BoxRuntimeException("Length must be in the range 0-31, inclusive.");
        }
        int bitmask = (1 << length) - 1 << start;
        return (number & bitmask) >>> start;
    }
}

