/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.conversion;

import java.io.IOException;
import java.util.Map;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumn;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.JSONUtil;
import ortus.boxlang.runtime.types.util.ListUtil;

@BoxBIF
@BoxMembers(value={@BoxMember(type=BoxLangType.CUSTOM, customType=Boolean.class, name="toJSON"), @BoxMember(type=BoxLangType.CUSTOM2, customType=Number.class, name="toJSON"), @BoxMember(type=BoxLangType.ARRAY, name="toJSON"), @BoxMember(type=BoxLangType.CLASS, name="toJSON"), @BoxMember(type=BoxLangType.QUERY, name="toJSON"), @BoxMember(type=BoxLangType.STRUCT, name="toJSON"), @BoxMember(type=BoxLangType.STRING, name="listToJSON"), @BoxMember(type=BoxLangType.STRING, name="toJSON")})
public class JSONSerialize
extends BIF {
    public JSONSerialize() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.var), new Argument(false, "string", Key.queryFormat, "row"), new Argument(false, "string", Key.useSecureJSONPrefix, false), new Argument(false, "boolean", Key.useCustomSerializer)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object obj = arguments.get(Key.var);
        String queryFormat = arguments.getAsString(Key.queryFormat).toLowerCase();
        if (queryFormat.equals("yes")) {
            queryFormat = "true";
        }
        if (queryFormat.equals("no")) {
            queryFormat = "false";
        }
        if (obj instanceof Query) {
            Query qry = (Query)obj;
            if (queryFormat.equals("row") || queryFormat.equals("false")) {
                obj = Struct.linkedOf("columns", qry.getColumns().keySet().stream().map(c -> c.getName()).toArray(String[]::new), "data", qry.getData());
            } else if (queryFormat.equals("column") || queryFormat.equals("true")) {
                Struct data = new Struct(IStruct.TYPES.LINKED);
                Map<Key, QueryColumn> cols = qry.getColumns();
                for (Key col : cols.keySet()) {
                    data.put(col, (Object)cols.get(col).getColumnData());
                }
                obj = Struct.linkedOf("rowCount", qry.size(), "columns", qry.getColumns().keySet().stream().map(c -> c.getName()).toArray(String[]::new), "data", data);
            } else if (queryFormat.equals("struct")) {
                obj = qry;
            } else {
                throw new BoxRuntimeException("Invalid queryFormat: " + queryFormat);
            }
        }
        if (arguments.get(BIF.__functionName).equals(Key.listToJSON)) {
            obj = ListUtil.asList(arguments.getAsString(Key.var), ",");
        }
        try {
            return JSONUtil.getJSONBuilder().asString(obj);
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error serializing to JSON", e);
        }
    }
}

