/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.conversion;

import java.util.Locale;
import org.apache.commons.lang3.math.NumberUtils;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="LSParseNumber")})
public class ParseNumber
extends BIF {
    private static final Array RADIX_VALUES = Array.of(new Object[]{"bin", "oct", "dec", "hex"});

    public ParseNumber() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.number), new Argument(false, "string", Key.locale), new Argument(false, "string", Key.radix)};
    }

    @Override
    public Number _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number parsed;
        String number = arguments.getAsString(Key.number);
        if (RADIX_VALUES.contains(arguments.getAsString(Key.locale).toLowerCase())) {
            arguments.put(Key.radix, (Object)arguments.getAsString(Key.locale));
            arguments.remove(Key.locale);
        }
        if (arguments.getAsString(Key.radix) != null) {
            return switch (arguments.getAsString(Key.radix).toLowerCase()) {
                case "bin" -> Integer.parseInt(number, 2);
                case "oct" -> Integer.parseInt(number, 8);
                case "dec" -> Double.parseDouble(number);
                case "hex" -> Integer.parseInt(number, 16);
                default -> throw new BoxRuntimeException("Invalid radix: " + arguments.getAsString(Key.radix));
            };
        }
        String value = arguments.getAsString(Key.number);
        Locale locale = LocalizationUtil.parseLocaleFromContext(context, arguments);
        Number number2 = parsed = NumberUtils.isCreatable(value) ? (Number)NumberCaster.cast(value) : (Number)LocalizationUtil.parseLocalizedNumber(arguments.get(Key.number), locale);
        if (parsed == null) {
            throw new BoxRuntimeException(String.format("The value [%s] could not be parsed using the locale [%s]", value, locale.getDisplayName()));
        }
        return parsed;
    }
}

