/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;

@BoxBIF
public class ToNumeric
extends BIF {
    public ToNumeric() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.value), new Argument(false, "any", Key.radix)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String inputValue = arguments.getAsString(Key.value);
        Object radixValue = arguments.get(Key.radix);
        if (radixValue == null) {
            return NumberCaster.cast(inputValue);
        }
        int numericRadix = this.convertStringToRadix(radixValue);
        if (inputValue.length() >= 20) {
            BigInteger bigInteger = new BigInteger(inputValue, numericRadix);
            return new BigDecimal(bigInteger);
        }
        return Long.parseLong(inputValue, numericRadix);
    }

    private int convertStringToRadix(Object oRadix) {
        String radixString;
        if (oRadix instanceof Number) {
            Number rn = (Number)oRadix;
            int radix = rn.intValue();
            if (radix >= 2 && radix <= 36) {
                return radix;
            }
            throw new BoxValidationException("Radix must be between 2 and 36.");
        }
        switch (radixString = StringCaster.cast(oRadix).toLowerCase()) {
            case "bin": {
                return 2;
            }
            case "oct": {
                return 8;
            }
            case "dec": {
                return 10;
            }
            case "hex": {
                return 16;
            }
        }
        throw new BoxValidationException("Invalid radix [" + radixString + "], valid values are [2-36,bin,oct,dec,hex]");
    }
}

