/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.conversion;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IType;

@BoxBIF
@BoxMember(type=BoxLangType.STRING)
public class ToString
extends BIF {
    public ToString() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.value), new Argument(false, "string", Key.encoding)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object obj = arguments.get(Key.value);
        if (obj == null) {
            return "";
        }
        CastAttempt<String> castAttempt = StringCaster.attempt(obj, arguments.getAsString(Key.encoding));
        if (castAttempt.wasSuccessful()) {
            return castAttempt.get();
        }
        if ((obj = DynamicObject.unWrap(obj)) instanceof IType) {
            IType type = (IType)obj;
            return type.asString();
        }
        return obj.toString();
    }
}

