/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.conversion;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.QueryCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMembers(value={@BoxMember(type=BoxLangType.ARRAY), @BoxMember(type=BoxLangType.STRUCT), @BoxMember(type=BoxLangType.QUERY)})
public class ToUnmodifiable
extends BIF {
    public ToUnmodifiable() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.value)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object inputValue = arguments.get(Key.value);
        CastAttempt<Array> castedArray = ArrayCaster.attempt(inputValue);
        if (castedArray.wasSuccessful()) {
            return castedArray.get().toUnmodifiable();
        }
        CastAttempt<IStruct> castedStruct = StructCaster.attempt(inputValue);
        if (castedStruct.wasSuccessful()) {
            return ((Struct)castedStruct.get()).toUnmodifiable();
        }
        CastAttempt<Query> castedQuery = QueryCaster.attempt(inputValue);
        if (castedQuery.wasSuccessful()) {
            return castedQuery.get().toUnmodifiable();
        }
        throw new BoxRuntimeException("Cannot convert value to Unmodifiable type as it is not a struct, array or query");
    }
}

