/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.decision;

import java.util.Arrays;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Closure;
import ortus.boxlang.runtime.types.Lambda;
import ortus.boxlang.runtime.types.UDF;

@BoxBIF
public class IsCustomFunction
extends BIF {
    public IsCustomFunction() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.object), new Argument(false, "string", Key.type)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String type = arguments.getAsString(Key.type);
        if (type == null || type.isEmpty()) {
            Object obj = arguments.get(Key.object);
            return obj instanceof Closure || obj instanceof Lambda || obj instanceof UDF;
        }
        Object value = arguments.get(Key.object);
        switch (CustomFunctionType.fromString(type).ordinal()) {
            case 0: {
                return value instanceof UDF;
            }
            case 2: {
                return value instanceof Lambda;
            }
            case 1: {
                return value instanceof Closure;
            }
        }
        return value instanceof Closure;
    }

    static enum CustomFunctionType {
        UDF,
        CLOSURE,
        LAMBDA;


        public static CustomFunctionType fromString(String type) {
            try {
                return CustomFunctionType.valueOf(type.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid type [%s], must be one of %s", type, Arrays.toString((Object[])CustomFunctionType.values())));
            }
        }
    }
}

