/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.decision;

import java.time.ZoneId;
import java.time.zone.ZoneRulesException;
import java.util.Locale;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.DoubleCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="IsNumericDate")})
public class IsDate
extends BIF {
    private static final Key numericDateFunction = Key.of("isNumericDate");

    public IsDate() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.date), new Argument(false, "string", Key.locale), new Argument(false, "string", Key.timezone)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        Object dateRef = arguments.get(Key.date);
        String timezone = arguments.getAsString(Key.timezone);
        String localeString = arguments.getAsString(Key.locale);
        if (bifMethodKey.equals(numericDateFunction)) {
            return DoubleCaster.attempt(dateRef).wasSuccessful();
        }
        if (dateRef instanceof DateTime) {
            return true;
        }
        if (localeString != null || timezone != null) {
            ZoneId zoneId = null;
            try {
                zoneId = timezone != null ? ZoneId.of(timezone) : LocalizationUtil.parseZoneId(timezone, context);
            }
            catch (ZoneRulesException e) {
                throw new BoxRuntimeException(String.format("The value [%s] is not a valid timezone.", timezone), e);
            }
            Locale locale = LocalizationUtil.getParsedLocale(localeString);
            try {
                new DateTime(StringCaster.cast(dateRef), locale, zoneId);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return DateTimeCaster.attempt(dateRef).wasSuccessful();
    }
}

