/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.decision;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.QueryCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="structIsEmpty"), @BoxBIF(alias="arrayIsEmpty")})
@BoxMembers(value={@BoxMember(type=BoxLangType.ARRAY), @BoxMember(type=BoxLangType.STRUCT), @BoxMember(type=BoxLangType.STRING), @BoxMember(type=BoxLangType.QUERY)})
public class IsEmpty
extends BIF {
    public IsEmpty() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.value)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object object = arguments.get(Key.value);
        if (object == null) {
            return true;
        }
        CastAttempt<Array> arrayAttempt = ArrayCaster.attempt(object);
        if (arrayAttempt.wasSuccessful()) {
            return arrayAttempt.get().isEmpty();
        }
        CastAttempt<IStruct> structAttempt = StructCaster.attempt(object);
        if (structAttempt.wasSuccessful()) {
            return structAttempt.get().isEmpty();
        }
        CastAttempt<Query> queryAttempt = QueryCaster.attempt(object);
        if (queryAttempt.wasSuccessful()) {
            return queryAttempt.get().isEmpty();
        }
        CastAttempt<String> stringAttempt = StringCaster.attempt(object);
        if (stringAttempt.wasSuccessful()) {
            return stringAttempt.get().isEmpty();
        }
        return false;
    }
}

