/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.decision;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.NetworkUtil;

@BoxBIF
public class IsIPv6
extends BIF {
    public IsIPv6() {
        this.declaredArguments = new Argument[]{new Argument(false, "string", Key.hostname)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        try {
            InetAddress[] addresses;
            if (arguments.containsKey(Key.hostname)) {
                String hostOrIP = arguments.getAsString(Key.hostname);
                addresses = InetAddress.getAllByName(hostOrIP);
            } else {
                addresses = InetAddress.getAllByName(NetworkUtil.getLocalHostname());
            }
            return Arrays.stream(addresses).anyMatch(Inet6Address.class::isInstance);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

