/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.decision;

import java.net.InetAddress;
import java.net.UnknownHostException;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;

@BoxBIF
public class IsLocalHost
extends BIF {
    public IsLocalHost() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.ip)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        try {
            String ipAddress = arguments.getAsString(Key.ip);
            return !ipAddress.trim().isEmpty() && InetAddress.getByName(ipAddress).isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

