/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.decision;

import java.util.Arrays;
import java.util.Map;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.GenericCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.ValidationUtil;

@BoxBIF
public class IsValid
extends BIF {
    public IsValid() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.type), new Argument(true, "any", Key.value), new Argument(false, "any", Key.min), new Argument(false, "any", Key.max), new Argument(false, "any", Key.pattern, "")};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        IsValidType type = IsValidType.fromString(arguments.getAsString(Key.type));
        Object min = arguments.get(Key.min);
        String pattern = arguments.getAsString(Key.pattern);
        if ((type == IsValidType.REGEX || type == IsValidType.REGULAR_EXPRESSION) && pattern.isEmpty()) {
            if (min != null) {
                pattern = min.toString();
            } else {
                throw new IllegalArgumentException("The pattern argument is required for the regex and regular_expression types.");
            }
        }
        return switch (type.ordinal()) {
            case 0 -> GenericCaster.attempt(context, arguments.get(Key.value), "any").wasSuccessful();
            case 1 -> GenericCaster.attempt(context, arguments.get(Key.value), "array").wasSuccessful();
            case 3 -> GenericCaster.attempt(context, arguments.get(Key.value), "boolean").wasSuccessful();
            case 9 -> GenericCaster.attempt(context, arguments.get(Key.value), "datetime").wasSuccessful();
            case 10 -> ValidationUtil.isFloat(arguments.get(Key.value));
            case 16 -> GenericCaster.attempt(context, arguments.get(Key.value), "query").wasSuccessful();
            case 22 -> GenericCaster.attempt(context, arguments.get(Key.value), "string").wasSuccessful();
            case 23 -> GenericCaster.attempt(context, arguments.get(Key.value), "struct").wasSuccessful();
            case 25 -> GenericCaster.attempt(context, arguments.get(Key.value), "time").wasSuccessful();
            case 31 -> GenericCaster.attempt(context, arguments.get(Key.value), "xml").wasSuccessful();
            case 2 -> ValidationUtil.isBinary(arguments.get(Key.value));
            case 7 -> ValidationUtil.isValidCreditCard(this.castAsStringOrNull(arguments.get(Key.value)));
            case 5 -> ValidationUtil.isClosure(arguments.get(Key.value));
            case 4, 6 -> ValidationUtil.isBoxClass(arguments.get(Key.value));
            case 12 -> ValidationUtil.isValidGUID(this.castAsStringOrNull(arguments.get(Key.value)));
            case 8 -> ValidationUtil.isValidEmail(this.castAsStringOrNull(arguments.get(Key.value)));
            case 11 -> ValidationUtil.isFunction(arguments.get(Key.value));
            case 13 -> ValidationUtil.isValidInteger(arguments.get(Key.value));
            case 14 -> ValidationUtil.isLambda(arguments.get(Key.value));
            case 15 -> ValidationUtil.isValidNumeric(arguments.get(Key.value));
            case 17 -> ValidationUtil.isValidRange(arguments.get(Key.value), NumberCaster.cast(arguments.get(Key.min)), NumberCaster.cast(arguments.get(Key.max)));
            case 18, 19 -> ValidationUtil.isValidPattern(this.castAsStringOrNull(arguments.get(Key.value)), pattern);
            case 20, 21 -> ValidationUtil.isValidSSN(this.castAsStringOrNull(arguments.get(Key.value)));
            case 24 -> ValidationUtil.isValidTelephone(this.castAsStringOrNull(arguments.get(Key.value)));
            case 27 -> ValidationUtil.isValidURL(this.castAsStringOrNull(arguments.get(Key.value)));
            case 26 -> ValidationUtil.isUDF(arguments.get(Key.value));
            case 29 -> ValidationUtil.isValidUUID(this.castAsStringOrNull(arguments.get(Key.value))) || ValidationUtil.isValidGUID(this.castAsStringOrNull(arguments.get(Key.value)));
            case 30 -> ValidationUtil.isValidVariableName(this.castAsStringOrNull(arguments.get(Key.value)));
            case 28 -> context.invokeFunction(Key.of("IsDate"), Map.of(Key.date, arguments.get(Key.value), Key.locale, "en_US"));
            case 32 -> ValidationUtil.isValidZipCode(this.castAsStringOrNull(arguments.get(Key.value)));
            default -> throw new IllegalArgumentException("Invalid type: " + String.valueOf((Object)type) + ". Valid types are: " + Arrays.toString(IsValidType.toArray()));
        };
    }

    public String castAsStringOrNull(Object value) {
        return StringCaster.cast(value, false);
    }

    private static enum IsValidType {
        ANY("any"),
        ARRAY("array"),
        BINARY("binary"),
        BOOLEAN("boolean"),
        CLASS("class"),
        CLOSURE("closure"),
        COMPONENT("component"),
        CREDITCARD("creditcard"),
        EMAIL("email"),
        DATE("date"),
        FLOAT("float"),
        FUNCTION("function"),
        GUID("guid"),
        INTEGER("integer"),
        LAMBDA("lambda"),
        NUMERIC("numeric"),
        QUERY("query"),
        RANGE("range"),
        REGEX("regex"),
        REGULAR_EXPRESSION("regular_expression"),
        SOCIAL_SECURITY_NUMBER("social_security_number"),
        SSN("ssn"),
        STRING("string"),
        STRUCT("struct"),
        TELEPHONE("telephone"),
        TIME("time"),
        UDF("udf"),
        URL("url"),
        USDATE("usdate"),
        UUID("uuid"),
        VARIABLENAME("variablename"),
        XML("xml"),
        ZIPCODE("zipcode");

        private final Key key;

        private IsValidType(String type) {
            this.key = Key.of(type);
        }

        public Key getKey() {
            return this.key;
        }

        public static String[] toArray() {
            return (String[])Arrays.stream(IsValidType.values()).map(val -> val.key.getName()).sorted().toArray(String[]::new);
        }

        public static boolean isValid(Key value) {
            for (IsValidType type : IsValidType.values()) {
                if (!type.getKey().equals(value)) continue;
                return true;
            }
            return false;
        }

        public static boolean isValid(String value) {
            return IsValidType.isValid(Key.of(value));
        }

        public static IsValidType fromString(String type) {
            try {
                return IsValidType.valueOf(type.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid type [%s], must be one of %s", type, Arrays.toString((Object[])IsValidType.values())));
            }
        }

        public String toString() {
            return this.key.getName();
        }
    }
}

