/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.encryption;

import java.nio.charset.Charset;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.EncryptionUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="EncryptBinary")})
public class Encrypt
extends BIF {
    public Encrypt() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.object), new Argument(true, "string", Key.key), new Argument(false, "string", Key.algorithm), new Argument(false, "string", Key.encoding, "UU"), new Argument(false, "any", Key.IVorSalt), new Argument(false, "integer", Key.iterations, 1000), new Argument(false, "boolean", Key.precise, true)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        if (arguments.get(Key.string) != null) {
            arguments.put(Key.object, arguments.get(Key.string));
        }
        Object content = arguments.get(Key.object);
        String algorithm = arguments.getAsString(Key.algorithm);
        if (algorithm == null) {
            algorithm = "AES";
        }
        String encoding = arguments.getAsString(Key.encoding);
        byte[] IVorSalt = null;
        if (arguments.get(Key.IVorSalt) != null) {
            IVorSalt = arguments.get(Key.IVorSalt) instanceof byte[] ? (byte[])arguments.get(Key.IVorSalt) : arguments.getAsString(Key.IVorSalt).getBytes(Charset.forName("UTF-8"));
        }
        return EncryptionUtil.encrypt(content, algorithm, arguments.getAsString(Key.key), encoding, IVorSalt, arguments.getAsInteger(Key.iterations));
    }
}

