/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.encryption;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.util.JSONUtil;
import ortus.boxlang.runtime.util.EncryptionUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="Hash40")})
@BoxMembers(value={@BoxMember(type=BoxLangType.STRING, name="hash"), @BoxMember(type=BoxLangType.STRUCT, name="hash"), @BoxMember(type=BoxLangType.ARRAY, name="hash"), @BoxMember(type=BoxLangType.DATETIME, name="hash")})
public class Hash
extends BIF {
    private static final String DEFAULT_ALGORITHM = "MD5";
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final Integer DEFAULT_ITERATIONS = 1;
    private static Object hashItem = null;

    public Hash() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.input), new Argument(false, "string", Key.algorithm, DEFAULT_ALGORITHM), new Argument(false, "string", Key.encoding, DEFAULT_ENCODING), new Argument(false, "integer", Key.numIterations, DEFAULT_ITERATIONS)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        hashItem = arguments.get(Key.input);
        byte[] hashBytes = null;
        Integer iterations = arguments.getAsInteger(Key.numIterations);
        String algorithm = arguments.getAsString(Key.algorithm);
        String charset = arguments.getAsString(Key.encoding);
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        if (bifMethodKey.equals(Key.hash40)) {
            algorithm = "SHA1";
        }
        if (hashItem instanceof String) {
            hashBytes = arguments.getAsString(Key.input).getBytes(Charset.forName(charset));
        } else if (hashItem instanceof Serializable) {
            try {
                hashBytes = SerializationUtils.serialize((Serializable)hashItem);
            }
            catch (SerializationException ns) {
                try {
                    hashBytes = JSONUtil.getJSONBuilder().asString(hashItem).getBytes();
                }
                catch (IOException e) {
                    throw new BoxIOException("The object provided could not be serialized to a byte array", e);
                }
            }
        } else {
            hashBytes = hashItem.toString().getBytes(Charset.forName(arguments.getAsString(Key.encoding)));
        }
        return EncryptionUtil.hash(hashBytes, algorithm, iterations);
    }
}

