/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.format;

import java.text.NumberFormat;
import java.util.Locale;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class DecimalFormat
extends BIF {
    public DecimalFormat() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.number), new Argument(false, "integer", Key.length, 2)};
    }

    @Override
    public String _invoke(IBoxContext context, ArgumentsScope arguments) {
        Locale locale = (Locale)context.getConfig().get(Key.locale);
        Number value = NumberCaster.cast(arguments.get(Key.number));
        int decimalPlaces = arguments.getAsInteger(Key.length);
        NumberFormat formatter = java.text.DecimalFormat.getInstance(locale);
        formatter.setMinimumFractionDigits(2);
        formatter.setMaximumFractionDigits(decimalPlaces);
        return formatter.format(value);
    }
}

