/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.format;

import java.util.Locale;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="LSNumberFormat")})
@BoxMember(type=BoxLangType.NUMERIC)
public class NumberFormat
extends BIF {
    public NumberFormat() {
        this.declaredArguments = new Argument[]{new Argument(true, "number", Key.number), new Argument(false, "string", Key.mask), new Argument(false, "string", Key.locale)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number value = arguments.getAsNumber(Key.number);
        String format = arguments.getAsString(Key.mask);
        Locale locale = LocalizationUtil.parseLocaleFromContext(context, arguments);
        java.text.NumberFormat formatter = LocalizationUtil.localizedDecimalFormatter(locale, LocalizationUtil.NUMBER_FORMAT_PATTERNS.get(LocalizationUtil.DEFAULT_NUMBER_FORMAT_KEY));
        String type = arguments.getAsString(Key.type);
        if (type != null) {
            formatter = LocalizationUtil.localizedCurrencyFormatter(locale, type);
        } else if (format != null) {
            Key formatKey;
            if (format.equals("$")) {
                format = "USD";
            }
            if (LocalizationUtil.COMMON_NUMBER_FORMATTERS.containsKey(formatKey = Key.of(format))) {
                formatter = (java.text.NumberFormat)LocalizationUtil.COMMON_NUMBER_FORMATTERS.get(formatKey);
            } else if (LocalizationUtil.NUMBER_FORMAT_PATTERNS.containsKey(formatKey)) {
                formatter = LocalizationUtil.localizedDecimalFormatter(locale, format);
            } else if (format.equals("ls$")) {
                formatter = LocalizationUtil.localizedCurrencyFormatter(locale);
            } else {
                if ((format = format.replaceAll("9", "0").replaceAll("_", "#")).substring(0, 1).equals("L")) {
                    format = format.substring(1, format.length());
                } else if (format.substring(0, 1).equals("C")) {
                    format = format.substring(1, format.length()).replace("0", "#");
                }
                formatter = LocalizationUtil.localizedDecimalFormatter(locale, format);
            }
        }
        return formatter.format(value);
    }
}

