/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.i18n;

import java.util.Locale;
import org.apache.commons.lang3.math.NumberUtils;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.DoubleCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="LSParseCurrency")})
public class ParseCurrency
extends BIF {
    public ParseCurrency() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string), new Argument(false, "string", Key.locale)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Double parsed;
        String value = arguments.getAsString(Key.string);
        Locale locale = LocalizationUtil.parseLocaleFromContext(context, arguments);
        Double d = parsed = NumberUtils.isCreatable(value) ? DoubleCaster.cast(value) : LocalizationUtil.parseLocalizedCurrency(arguments.get(Key.string), locale);
        if (parsed == null) {
            throw new BoxRuntimeException(String.format("The value [%s] could not be parsed using the locale [%s]", value, locale.getDisplayName()));
        }
        return parsed;
    }
}

