/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.i18n;

import java.util.Locale;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIF
public class SetLocale
extends BIF {
    public SetLocale() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.locale)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Locale locale = LocalizationUtil.parseLocale(arguments.getAsString(Key.locale));
        if (locale == null) {
            throw new BoxRuntimeException(String.format("The Locale requested, [%s], is not a valid Locale for this runtime.", arguments.getAsString(Key.locale)));
        }
        context.getParentOfType(RequestBoxContext.class).setLocale(locale);
        return LocalizationUtil.getLocaleDisplayName(locale);
    }
}

