/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class CreateTempDirectory
extends BIF {
    public CreateTempDirectory() {
        this.declaredArguments = new Argument[]{new Argument(false, "string", Key.directory, FileSystemUtil.getTempDirectory()), new Argument(false, "string", Key.prefix, "")};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Path directory = Path.of(arguments.getAsString(Key.directory), new String[0]).toAbsolutePath();
        String prefix = arguments.getAsString(Key.prefix);
        try {
            return Files.createTempDirectory(directory, prefix.length() > 0 ? prefix : null, new FileAttribute[0]).toFile().getCanonicalPath();
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }
}

