/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class DirectoryCopy
extends BIF {
    public DirectoryCopy() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.source), new Argument(true, "string", Key.destination), new Argument(false, "boolean", Key.recurse, false), new Argument(false, "string", Key.filter, "*"), new Argument(false, "boolean", Key.createPath, true)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String sourcePath = arguments.getAsString(Key.source);
        String destinationPath = arguments.getAsString(Key.destination);
        if (!FileSystemUtil.exists(sourcePath).booleanValue()) {
            sourcePath = FileSystemUtil.expandPath(context, sourcePath).absolutePath().toString();
        }
        destinationPath = FileSystemUtil.expandPath(context, destinationPath).absolutePath().toString();
        FileSystemUtil.copyDirectory(sourcePath, destinationPath, arguments.getAsBoolean(Key.recurse), arguments.getAsString(Key.filter), arguments.getAsBoolean(Key.createPath));
        return null;
    }
}

