/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.nio.file.Path;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class DirectoryCreate
extends BIF {
    public DirectoryCreate() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.path), new Argument(false, "boolean", Key.createPath, true), new Argument(false, "boolean", Key.ignoreExists, false), new Argument(false, "string", Key.mode)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String targetDirectory = FileSystemUtil.expandPath(context, arguments.getAsString(Key.path)).absolutePath().toString();
        Boolean createPath = arguments.getAsBoolean(Key.createPath);
        Boolean ignoreExists = arguments.getAsBoolean(Key.ignoreExists);
        String mode = arguments.getAsString(Key.mode);
        if (!ignoreExists.booleanValue() && FileSystemUtil.exists(targetDirectory).booleanValue()) {
            throw new BoxRuntimeException("The directory [" + Path.of(targetDirectory, new String[0]).toAbsolutePath().toString() + "] already exists. Set the boolean argument ignoreExists to true to prevent this error");
        }
        FileSystemUtil.createDirectory(targetDirectory, createPath, mode);
        return null;
    }
}

