/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class DirectoryDelete
extends BIF {
    public DirectoryDelete() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.path), new Argument(true, "boolean", Key.recursive, false)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String directoryPath = arguments.getAsString(Key.path);
        if (!FileSystemUtil.exists(directoryPath).booleanValue()) {
            directoryPath = FileSystemUtil.expandPath(context, directoryPath).absolutePath().toString();
        }
        FileSystemUtil.deleteDirectory(directoryPath, arguments.getAsBoolean(Key.recursive));
        return null;
    }
}

