/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.stream.Stream;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class DirectoryList
extends BIF {
    public DirectoryList() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.path), new Argument(true, "boolean", Key.recurse, false), new Argument(false, "string", Key.listInfo, "path"), new Argument(false, "any", Key.filter), new Argument(false, "string", Key.sort, "name"), new Argument(false, "string", Key.type, "all")};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String returnType = arguments.getAsString(Key.listInfo).toLowerCase();
        String directoryPath = arguments.getAsString(Key.path);
        if (!FileSystemUtil.exists(directoryPath).booleanValue()) {
            directoryPath = FileSystemUtil.expandPath(context, directoryPath).absolutePath().toString();
        }
        if (arguments.get(Key.filter) instanceof Function) {
            arguments.put(Key.filter, (Object)this.createPredicate(context, (Function)arguments.get(Key.filter)));
        }
        Stream<Path> listing = FileSystemUtil.listDirectory(directoryPath, arguments.getAsBoolean(Key.recurse), arguments.get(Key.filter), arguments.getAsString(Key.sort), arguments.getAsString(Key.type));
        return switch (returnType) {
            case "name" -> this.listingToNames(listing);
            case "query" -> this.listingToQuery(listing);
            case "querynames" -> this.listingToQueryNames(listing, Paths.get(directoryPath, new String[0]));
            default -> this.listingToPaths(listing);
        };
    }

    public Array listingToPaths(Stream<Path> listing) {
        return ArrayCaster.cast(listing.map(item -> item.toAbsolutePath().toString()).toArray());
    }

    public Array listingToNames(Stream<Path> listing) {
        return ArrayCaster.cast(listing.map(item -> item.getFileName().toString()).toArray());
    }

    public Query listingToQuery(Stream<Path> listing) {
        Query listingQuery = new Query();
        listingQuery.addColumn(Key._NAME, QueryColumnType.VARCHAR).addColumn(Key.size, QueryColumnType.BIGINT).addColumn(Key.type, QueryColumnType.VARCHAR).addColumn(Key.dateLastModified, QueryColumnType.TIMESTAMP).addColumn(Key.attributes, QueryColumnType.VARCHAR).addColumn(Key.mode, QueryColumnType.VARCHAR).addColumn(Key.directory, QueryColumnType.VARCHAR);
        listing.forEachOrdered(item -> {
            try {
                listingQuery.addRow(new Object[]{item.getFileName().toString(), Files.isDirectory(item, new LinkOption[0]) ? 0L : Files.size(item), Files.isDirectory(item, new LinkOption[0]) ? "Dir" : "File", new DateTime(Files.getLastModifiedTime(item, new LinkOption[0]).toInstant()), DirectoryList.getAttributes(item), "", item.getParent().toAbsolutePath().toString()});
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        });
        return listingQuery;
    }

    public Query listingToQueryNames(Stream<Path> listing, Path basePath) {
        Query listingQuery = new Query();
        listingQuery.addColumn(Key._NAME, QueryColumnType.VARCHAR);
        listing.forEachOrdered(item -> listingQuery.addRow(new Object[]{basePath.relativize((Path)item).toString()}));
        return listingQuery;
    }

    private static String getAttributes(Path file) {
        Object attributes = "";
        if (Files.isReadable(file)) {
            attributes = (String)attributes + "R";
        }
        if (Files.isWritable(file)) {
            attributes = (String)attributes + "W";
        }
        if (Files.isExecutable(file)) {
            attributes = (String)attributes + "X";
        }
        try {
            if (Files.isHidden(file)) {
                attributes = (String)attributes + "H";
            }
        }
        catch (IOException e) {
            attributes = "";
        }
        return attributes;
    }

    private Predicate<Path> createPredicate(IBoxContext context, Function closure) {
        return path -> BooleanCaster.cast(context.invokeFunction((Object)closure, new Object[]{path.toString()}));
    }
}

