/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.io.File;
import java.nio.file.InvalidPathException;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class ExpandPath
extends BIF {
    public ExpandPath() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.path)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String path = arguments.getAsString(Key.path);
        boolean hasTrailingSlash = path.endsWith("/") || path.endsWith("\\");
        try {
            Object pathStr = FileSystemUtil.expandPath(context, path, context.findBaseTemplate()).absolutePath().toString();
            if (!(!hasTrailingSlash || ((String)pathStr).endsWith("/") && ((String)pathStr).endsWith("\\"))) {
                pathStr = (String)pathStr + File.separator;
            }
            return pathStr;
        }
        catch (InvalidPathException e) {
            return path;
        }
    }
}

