/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.File;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class FileAppend
extends BIF {
    public FileAppend() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.file), new Argument(true, "any", Key.data), new Argument(false, "string", Key.charset, "utf-8")};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        File file = null;
        if (arguments.get(Key.file) instanceof File) {
            file = (File)arguments.get(Key.file);
        } else if (arguments.get(Key.file) instanceof String) {
            String filePath = FileSystemUtil.expandPath(context, arguments.getAsString(Key.file)).absolutePath().toString();
            file = new File(filePath, "append", arguments.getAsString(Key.charset), false);
        } else {
            throw new BoxRuntimeException("The file argumennt [" + arguments.getAsString(Key.file) + "] is not an open file stream or string path.");
        }
        file.append(arguments.getAsString(Key.data));
        if (arguments.get(Key.file) instanceof String) {
            file.close();
        }
        return null;
    }
}

