/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class FileCopy
extends BIF {
    public FileCopy() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.source), new Argument(true, "string", Key.destination), new Argument(false, "boolean", Key.createPath, true)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        arguments.put(Key.source, (Object)FileSystemUtil.expandPath(context, arguments.getAsString(Key.source)).absolutePath().toString());
        arguments.put(Key.destination, (Object)FileSystemUtil.expandPath(context, arguments.getAsString(Key.destination)).absolutePath().toString());
        if (!this.runtime.getConfiguration().security.isFileOperationAllowed(arguments.getAsString(Key.destination))) {
            throw new BoxRuntimeException("The destination path contains an extension disallowed by the runtime security settings.");
        }
        Path sourcePath = Path.of(arguments.getAsString(Key.source), new String[0]);
        Path destinationPath = Path.of(arguments.getAsString(Key.destination), new String[0]);
        Path destinationDirectory = destinationPath.getParent();
        Boolean createPaths = arguments.getAsBoolean(Key.createPath);
        if (createPaths.booleanValue() && !Files.exists(destinationDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(destinationDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
        try {
            Files.copy(sourcePath, destinationPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        return null;
    }
}

