/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class FileExists
extends BIF {
    public FileExists() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.source), new Argument(true, "boolean", Key.allowRealPath, true)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String filePath = arguments.getAsString(Key.source);
        Boolean allowRealPath = arguments.getAsBoolean(Key.allowRealPath);
        try {
            if (!allowRealPath.booleanValue() && Path.of(filePath, new String[0]).isAbsolute()) {
                throw new BoxRuntimeException("The file or path argument [" + filePath + "] is an absolute path. This is disallowed when the allowRealPath argument is set to false.");
            }
            if (!FileSystemUtil.exists(filePath).booleanValue()) {
                filePath = FileSystemUtil.expandPath(context, filePath).toString();
            }
            return FileSystemUtil.exists(filePath) != false && !Files.isDirectory(Path.of(filePath, new String[0]), new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }
}

