/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class FileGetMimeType
extends BIF {
    public FileGetMimeType() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.file), new Argument(false, "boolean", Key.strict, true)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String filePath = FileSystemUtil.expandPath(context, arguments.getAsString(Key.file)).absolutePath().toString();
        Boolean strict = arguments.getAsBoolean(Key.strict);
        if (!filePath.substring(0, 4).equalsIgnoreCase("http")) {
            filePath = FileSystemUtil.expandPath(context, filePath).absolutePath().toString();
        } else if (strict.booleanValue()) {
            throw new BoxRuntimeException("The file [" + arguments.getAsString(Key.file) + "] is a URL. To retrieve the mimetype of a URL set the strict argument to false.");
        }
        String mimeType = null;
        if (strict.booleanValue()) {
            Path filePathObject = Path.of(filePath, new String[0]);
            try {
                if (!Files.exists(filePathObject, new LinkOption[0])) {
                    throw new BoxRuntimeException("The file [" + arguments.getAsString(Key.file) + "] does not exist. To retrieve the mimetype of a non-existent file set the strict argument to false.");
                }
                if (Files.size(filePathObject) == 0L) {
                    throw new BoxRuntimeException("The file [" + arguments.getAsString(Key.file) + "] is empty. To retrieve the mimetype of a empty file set the strict argument to false.");
                }
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
        if ((mimeType = FileSystemUtil.getMimeType(filePath)) == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }
}

