/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.nio.file.Path;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.File;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="GetFileInfo")})
@BoxMember(type=BoxLangType.FILE)
public class FileInfo
extends BIF {
    public FileInfo() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.file)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object file = arguments.get(Key.file);
        Path filePath = null;
        if (file instanceof File) {
            File fileObj = (File)file;
            filePath = fileObj.getPath();
        } else {
            filePath = FileSystemUtil.expandPath(context, StringCaster.cast(file)).absolutePath();
        }
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        Boolean verbose = bifMethodKey.equals(Key.getFileInfo);
        return FileSystemUtil.info(filePath, verbose);
    }
}

