/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class FileMove
extends BIF {
    public FileMove() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.source), new Argument(true, "string", Key.destination)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String sourcePath = FileSystemUtil.expandPath(context, arguments.getAsString(Key.source)).absolutePath().toString();
        String destinationPath = FileSystemUtil.expandPath(context, arguments.getAsString(Key.destination)).absolutePath().toString();
        if (!this.runtime.getConfiguration().security.isFileOperationAllowed(destinationPath)) {
            throw new BoxRuntimeException("The destination path contains an extension disallowed by the runtime security settings.");
        }
        FileSystemUtil.move(sourcePath, destinationPath);
        return null;
    }
}

