/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.util.Set;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.File;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class FileOpen
extends BIF {
    public FileOpen() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.file), new Argument(false, "string", Key.mode, "read"), new Argument(false, "string", Key.charset, "utf-8"), new Argument(false, "boolean", Key.seekable, null, Set.of())};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String filePath = arguments.getAsString(Key.file);
        if (!FileSystemUtil.exists(filePath).booleanValue()) {
            filePath = FileSystemUtil.expandPath(context, filePath).absolutePath().toString();
        }
        return new File(filePath, arguments.getAsString(Key.mode), arguments.getAsString(Key.charset), arguments.getAsBoolean(Key.seekable));
    }
}

