/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="FileReadBinary")})
public class FileRead
extends BIF {
    public FileRead() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.filepath), new Argument(false, "string", Key.charsetOrBufferSize), new Argument(false, "string", Key.charset), new Argument(false, "string", Key.buffersize)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String charsetOrBufferSize = arguments.getAsString(Key.charsetOrBufferSize);
        String charset = arguments.getAsString(Key.charset);
        Integer bufferSize = arguments.getAsInteger(Key.buffersize);
        String filePath = arguments.getAsString(Key.filepath);
        if (charsetOrBufferSize != null) {
            if (IntegerCaster.isInteger(charsetOrBufferSize)) {
                bufferSize = IntegerCaster.cast(charsetOrBufferSize);
            } else {
                charset = charsetOrBufferSize;
            }
        }
        if (!filePath.substring(0, 4).equalsIgnoreCase("http")) {
            filePath = FileSystemUtil.expandPath(context, filePath).absolutePath().toString();
        }
        return FileSystemUtil.read(filePath, charset, bufferSize);
    }
}

