/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.File;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
@BoxMember(type=BoxLangType.FILE)
public class FileSetLastModified
extends BIF {
    public FileSetLastModified() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.file), new Argument(true, "any", Key.date)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        File file = null;
        if (arguments.get(Key.file) instanceof File) {
            file = (File)arguments.get(Key.file);
        } else if (arguments.get(Key.file) instanceof String) {
            file = new File(FileSystemUtil.expandPath(context, arguments.getAsString(Key.file)).absolutePath().toString(), "append", arguments.getAsString(Key.charset), false);
        } else {
            throw new BoxRuntimeException("The file argumennt [" + arguments.getAsString(Key.file) + "] is not an open file stream or string path.");
        }
        file.setLastModifiedTime(arguments.getAsDateTime(Key.date));
        if (arguments.get(Key.file) instanceof String) {
            file.close();
            return null;
        }
        return file;
    }
}

