/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class FileWrite
extends BIF {
    public FileWrite() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.file), new Argument(true, "any", Key.data), new Argument(false, "string", Key.charset, "utf-8"), new Argument(false, "boolean", Key.createPath, false)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String filePath = FileSystemUtil.expandPath(context, arguments.getAsString(Key.file)).absolutePath().toString();
        Object fileContent = arguments.get(Key.data);
        String charset = arguments.getAsString(Key.charset);
        Boolean createPath = arguments.getAsBoolean(Key.createPath);
        if (fileContent instanceof String) {
            FileSystemUtil.write(filePath, arguments.getAsString(Key.data), charset, createPath);
        } else if (fileContent instanceof byte[]) {
            byte[] barr = (byte[])fileContent;
            FileSystemUtil.write(filePath, barr, createPath);
        } else {
            FileSystemUtil.write(filePath, StringCaster.cast(arguments.get(Key.data)), charset, createPath);
        }
        return null;
    }
}

