/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class GetCanonicalPath
extends BIF {
    public GetCanonicalPath() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.path)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String path = arguments.getAsString(Key.path);
        try {
            return Path.of(FileSystemUtil.expandPath(context, path).absolutePath().toString(), new String[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (InvalidPathException e) {
            return path;
        }
        catch (IOException e) {
            return path;
        }
    }
}

