/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.io;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
public class GetDirectoryFromPath
extends BIF {
    public GetDirectoryFromPath() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.path)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String path = FileSystemUtil.expandPath(context, arguments.getAsString(Key.path)).absolutePath().toString();
        if (path.endsWith("/") || path.endsWith("\\")) {
            return path;
        }
        int lastSeparator = path.lastIndexOf("/");
        if (lastSeparator == -1) {
            lastSeparator = path.lastIndexOf("\\");
        }
        if (lastSeparator == -1) {
            return "/";
        }
        return path.substring(0, lastSeparator + 1);
    }
}

