/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.java;

import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyService;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class CreateDynamicProxy
extends BIF {
    ClassLocator classLocator = BoxRuntime.getInstance().getClassLocator();

    public CreateDynamicProxy() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key._CLASS), new Argument(true, "any", Key.interfaces)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        IClassRunnable classToProxy;
        Object oClass = arguments.get(Key._CLASS);
        Object oInterfaces = arguments.get(Key.interfaces);
        if (oClass instanceof IClassRunnable) {
            IClassRunnable classRunnable;
            classToProxy = classRunnable = (IClassRunnable)oClass;
        } else {
            String className = StringCaster.cast(oClass);
            classToProxy = (IClassRunnable)this.classLocator.load(context, className, "bx", false, context.getCurrentImports()).invokeConstructor(context).unWrapBoxLangClass();
        }
        CastAttempt<Array> arrayAttemp = ArrayCaster.attempt(oInterfaces);
        Array interfacesToImplement = arrayAttemp.wasSuccessful() ? arrayAttemp.get() : Array.of(new Object[]{StringCaster.cast(oInterfaces)});
        if (interfacesToImplement.isEmpty()) {
            throw new BoxRuntimeException("At least one interface must be passed to create a dynamic proxy");
        }
        return InterfaceProxyService.buildGenericProxy(context, (Object)classToProxy, null, interfacesToImplement, (ClassLoader)context.getParentOfType(RequestBoxContext.class).getRequestClassLoader());
    }
}

