/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.jdbc;

import java.util.Set;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.IJDBCCapableContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.jdbc.ConnectionManager;
import ortus.boxlang.runtime.jdbc.ExecutedQuery;
import ortus.boxlang.runtime.jdbc.PendingQuery;
import ortus.boxlang.runtime.jdbc.QueryOptions;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIF
public class QueryExecute
extends BIF {
    public QueryExecute() {
        this.declaredArguments = new Argument[]{new Argument(true, "String", Key.sql, Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Argument(false, "any", Key.params, (Object)new Array(), Set.of(Validator.typeOneOf("array", "struct"))), new Argument(false, "struct", Key.options)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        IJDBCCapableContext jdbcContext = context.getParentOfType(IJDBCCapableContext.class);
        ConnectionManager connectionManager = jdbcContext.getConnectionManager();
        CastAttempt<IStruct> optionsAsStruct = StructCaster.attempt(arguments.get(Key.options));
        QueryOptions options = new QueryOptions(optionsAsStruct.getOrDefault(new Struct()));
        String sql = arguments.getAsString(Key.sql);
        Object bindings = arguments.get(Key.params);
        PendingQuery pendingQuery = new PendingQuery(sql, bindings, options);
        ExecutedQuery executedQuery = pendingQuery.execute(connectionManager);
        if (options.wantsResultStruct()) {
            assert (options.resultVariableName != null);
            ExpressionInterpreter.setVariable(context, options.resultVariableName, executedQuery.getResults().getMetaData());
        }
        return options.castAsReturnType(executedQuery);
    }
}

