/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Acos
extends BIF {
    public Acos() {
        this.declaredArguments = new Argument[]{new Argument(true, "double", Key.number)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        double value = arguments.getAsDouble(Key.number);
        if (value < -1.0 || value > 1.0) {
            throw new BoxRuntimeException("Input value must be in the range [-1, 1] for ACos function.");
        }
        return StrictMath.acos(value);
    }
}

