/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.MathContext;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Atn
extends BIF {
    public Atn() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number num = arguments.getAsNumber(Key.number);
        if (num instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)num;
            return this.atan(bd, MathUtil.getMathContext());
        }
        return StrictMath.atan(num.doubleValue());
    }

    private BigDecimal atan(BigDecimal x, MathContext mc) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal term = x;
        BigDecimal xSquared = x.multiply(x, mc);
        int n = 1;
        BigDecimal threshold = BigDecimal.ONE.scaleByPowerOfTen(-mc.getPrecision());
        while (term.abs().compareTo(threshold) > 0) {
            result = n % 2 != 0 ? result.add(term, mc) : result.subtract(term, mc);
            term = term.multiply(xSquared, mc).divide(BigDecimal.valueOf(2 * n + 1), mc);
            ++n;
        }
        return result;
    }
}

