/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.MathContext;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Cos
extends BIF {
    private static final BigDecimal MINUS_ONE = BigDecimal.valueOf(-1L);
    private static final BigDecimal THRESHOLD = new BigDecimal("1E-10");
    private static final BigDecimal TWO_PI = BigDecimal.valueOf(Math.PI * 2);

    public Cos() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number num = arguments.getAsNumber(Key.number);
        if (num instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)num;
            return Cos.cos(bd, MathUtil.getMathContext());
        }
        return StrictMath.cos(num.doubleValue());
    }

    public static BigDecimal cos(BigDecimal x, MathContext mc) {
        return new BigDecimal(StrictMath.cos(x.doubleValue()));
    }
}

