/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.MathContext;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Exp
extends BIF {
    public Exp() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number value = arguments.getAsNumber(Key.number);
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return Exp.exp(bd, MathUtil.getMathContext());
        }
        return StrictMath.exp(value.doubleValue());
    }

    public static BigDecimal exp(BigDecimal x, MathContext mc) {
        BigDecimal result = BigDecimal.ONE;
        BigDecimal term = BigDecimal.ONE;
        BigDecimal n = BigDecimal.ONE;
        BigDecimal threshold = new BigDecimal("1E-10");
        while (term.abs().compareTo(threshold) > 0) {
            term = term.multiply(x, mc).divide(n, mc);
            result = result.add(term, mc);
            n = n.add(BigDecimal.ONE);
        }
        return result;
    }
}

